<?php if (!defined('ABSPATH')) exit; // Exit if accessed directly ?>

<?php do_action('wpo_wcpdf_before_document', $this->get_type(), $this->order); ?>

    <table class="head container">
        <tr>
            <td class="header">
                <?php if ($this->has_header_logo()) : ?>
                    <?php do_action('wpo_wcpdf_before_shop_logo', $this->get_type(), $this->order); ?>
                    <?php $this->header_logo(); ?>
                    <?php do_action('wpo_wcpdf_after_shop_logo', $this->get_type(), $this->order); ?>
                <?php else : ?>
                    <?php $this->title(); ?>
                <?php endif; ?>
                <div class="shop-address" style="font-size: 13px; font-weight: 400; line-height: 15px; margin: 5px 0;">
					PROMEZ Online Shop<br>
                    Konto: 10007<br>
                    Kragman GmbH <br>
                    Werner-von-Siemens-Straße 2-6, <br> 76646 Bruchsal,<br>
                    Email: info@promez.ro
                </div>
            </td>
            <td class="shop-info">
                <!--                --><?php //do_action('wpo_wcpdf_before_shop_name', $this->get_type(), $this->order); ?>
                <!--                <div class="shop-name"><h3>--><?php //$this->shop_name(); ?><!--</h3></div>-->
                <!--                --><?php //do_action('wpo_wcpdf_after_shop_name', $this->get_type(), $this->order); ?>
                <!--                --><?php //do_action('wpo_wcpdf_before_shop_address', $this->get_type(), $this->order); ?>
                <!--                <div class="shop-address">--><?php //$this->shop_address(); ?><!--</div>-->
                <!--                --><?php //do_action('wpo_wcpdf_after_shop_address', $this->get_type(), $this->order); ?>
            </td>
        </tr>
    </table>

<?php do_action('wpo_wcpdf_before_document_label', $this->get_type(), $this->order); ?>

<?php if ($this->has_header_logo()) : ?>
    <h1 class="document-type-label">Rechnung</h1>
<?php endif; ?>

<?php do_action('wpo_wcpdf_after_document_label', $this->get_type(), $this->order); ?>

    <table class="order-data-addresses">
        <tr>
            <td class="address billing-address">
                <?php do_action('wpo_wcpdf_before_billing_address', $this->get_type(), $this->order); ?>
                <p><?php $this->billing_address(); ?></p>
                <?php do_action('wpo_wcpdf_after_billing_address', $this->get_type(), $this->order); ?>
                <?php if (isset($this->settings['display_email'])) : ?>
                    <div class="billing-email"><?php $this->billing_email(); ?></div>
                <?php endif; ?>
                <?php if (isset($this->settings['display_phone'])) : ?>
                    <div class="billing-phone"><?php $this->billing_phone(); ?></div>
                <?php endif; ?>
            </td>
            <td class="address shipping-address">
                <?php if ($this->show_shipping_address()) : ?>
                    <h3>Lieferort:</h3>
                    <?php do_action('wpo_wcpdf_before_shipping_address', $this->get_type(), $this->order); ?>
                    <p><?php $this->shipping_address(); ?></p>
                    <?php do_action('wpo_wcpdf_after_shipping_address', $this->get_type(), $this->order); ?>
                    <?php if (isset($this->settings['display_phone'])) : ?>
                        <div class="shipping-phone"><?php $this->shipping_phone(); ?></div>
                    <?php endif; ?>
                <?php endif; ?>
            </td>
            <td class="order-data">
                <table>
                    <?php do_action('wpo_wcpdf_before_order_data', $this->get_type(), $this->order); ?>
                    <?php if (isset($this->settings['display_number'])) : ?>
                        <tr class="invoice-number">
                            <th>Rechnungsnummer:</th>
                            <td><?php $this->number($this->get_type()); ?></td>
                        </tr>
                    <?php endif; ?>
                    <?php if (isset($this->settings['display_date'])) : ?>
                        <tr class="invoice-date">
                            <th>Rechnungsdatum:</th>
                            <td><?php $this->date($this->get_type()); ?></td>
                        </tr>
                        <tr class="invoice-date">
                            <th>Lieferdatum:</th>
                            <td><?php $this->date($this->get_type()); ?></td>
                        </tr>
                    <?php endif; ?>
                    <?php if ($this->show_due_date()) : ?>
                        <tr class="due-date">
                            <th><?php $this->due_date_title(); ?></th>
                            <td><?php $this->due_date(); ?></td>
                        </tr>
                    <?php endif; ?>
                    <tr class="order-number">
                        <th>Bestellnummer:</th>
                        <td><?php $this->order_number(); ?></td>
                    </tr>

                    <!--                    --><?php //if ($this->get_payment_method()) : ?>
                    <!--                        <tr class="payment-method">-->
                    <!--                            <th>--><?php //$this->payment_method_title(); ?><!--</th>-->
                    <!--                            <td>--><?php //$this->payment_method(); ?><!--</td>-->
                    <!--                        </tr>-->
                    <!--                    --><?php //endif; ?>
                    <?php do_action('wpo_wcpdf_after_order_data', $this->get_type(), $this->order); ?>
                </table>
            </td>
        </tr>
    </table>

<?php do_action('wpo_wcpdf_before_order_details', $this->get_type(), $this->order); ?>

    <table class="order-details">
        <thead>
        <tr>
            <?php foreach (wpo_wcpdf_get_simple_template_default_table_headers($this) as $column_class => $column_title) : ?>
                <th class="<?php echo esc_attr($column_class); ?>"><?php echo esc_html($column_title); ?></th>
            <?php endforeach; ?>
        </tr>
        </thead>
        <tbody>
        <?php
        $index = 0;
        foreach ($this->get_order_items() as $item_id => $item) :
            $index++;

            $product = $item['product'];
            $qty = $item['quantity'];

            $is_bundle = $product && method_exists($product, 'get_bundled_items') && !empty($product->get_bundled_items());

            /*
             * 1. AFIȘĂM BOX-UL NORMAL ÎN FACTURĂ
             * (numele lui + prețul lui real)
             */
            ?>
            <tr class="<?php echo esc_html($item['row_class']); ?>">
                <td class="index"><?php echo $index; ?></td>
                <td class="quantity"><?php echo esc_html($qty); ?>.00</td>
                <td class="cod">
                    <?php if (!empty($product->get_sku())) : ?>
                        <p class="sku"><?php echo $product->get_sku(); ?></p>
                    <?php endif; ?>
                </td>
                <td class="product">
                    <p class="item-name"><strong><?php echo $product->get_name(); ?></strong></p>
                </td>
                <td class="tva">7.00%</td>
                <td class="price"><?php echo esc_html($item['order_price']); ?>€</td>
                <td class="price last_price"><?php echo esc_html($product->get_price() * $qty); ?>€</td>
            </tr>
            <?php

            /*
             * 2. Dacă e bundle → afișăm PRODUSELE DIN BOX
             */
            if ($is_bundle) {

                $bundled_items = $product->get_bundled_items();

                foreach ($bundled_items as $bundled_item) {

                    $bundled_product = $bundled_item->get_product();
                    if (!$bundled_product) continue;

                    $qty_per_bundle = $bundled_item->get_quantity();
                    $qty_total = $qty_per_bundle * $qty;
                    $sku = $bundled_product->get_sku();
                    ?>

                    <tr class="child-of-bundle">
                        <td class="index"></td> <!-- gol pentru indentare -->
                        <td class="quantity"><?php echo esc_html($qty_total); ?>.00</td>
                        <td class="cod">
                            <?php if (!empty($sku)) : ?>
                                <p class="sku"><?php echo $sku; ?></p>
                            <?php endif; ?>
                        </td>
                        <td class="product">
                            <p class="item-name">– <?php echo $bundled_product->get_name(); ?></p>
                        </td>

                        <!-- Prețurile sunt ascunse conform soluției -->
                        <td class="tva"></td>
                        <td class="price">-</td>
                        <td class="price last_price">-</td>
                    </tr>

                    <?php
                }
            }
            ?>


        <?php endforeach; ?>
        <?php
        $tips_raw = get_post_meta($this->order->get_id(), '_custom_tip_amount', true);
        $tips = is_numeric($tips_raw) ? (float)$tips_raw : 0.00;
        if ($tips) : ?>
            <?php echo $index++ ?>
            <tr>
                <td><?php echo $index ?></td>
                <td class="quantity">1.00</td>
                <td class="cod"></td>
                <td class="product">Tip</td>
                <td class="tva">0.00%</td>
                <td class="price"><?php echo wc_price($tips); ?></td>
                <td class="price last_price"><?php echo wc_price($tips); ?></td>
            </tr>
        <?php endif; ?>
        <!--        --><?php //var_dump($this->order); ?>

        <?php echo $index++;
        $shipping_total = $this->order->shipping_total;
        ?>
        <tr>
            <td><?php echo $index ?></td>
            <td class="quantity">1.00</td>
            <td class="cod"></td>
            <td class="product">DPD</td>
            <td class="tva">7.00%</td>
            <?php
            if ($shipping_total > 0) { ?>
                <td class="price">9.99€</td>
                <td class="price last_price"><?php echo $shipping_total ?>€</td>
            <?php } else { ?>
                <td class="price">0.00€</td>
                <td class="price last_price">0,00€</td>

            <?php } ?>
        </tr>
        </tbody>
    </table>
<?php //var_dump($this->order->discount_total); ?>

    <table class="notes-totals">
        <tbody>
        <tr class="no-borders">
            <td class="no-borders notes-cell">
                <?php do_action('wpo_wcpdf_before_document_notes', $this->get_type(), $this->order); ?>
                <?php if ($this->get_document_notes()) : ?>
                    <div class="document-notes">
                        <h3><?php $this->notes_title(); ?></h3>
                        <?php $this->document_notes(); ?>
                    </div>
                <?php endif; ?>
                <?php do_action('wpo_wcpdf_after_document_notes', $this->get_type(), $this->order); ?>
                <?php do_action('wpo_wcpdf_before_customer_notes', $this->get_type(), $this->order); ?>
                <!--                --><?php //if ($this->get_shipping_notes()) : ?>
                <!--                    <div class="customer-notes">-->
                <!--                        <h3>--><?php //$this->customer_notes_title(); ?><!--</h3>-->
                <!--                        --><?php //$this->shipping_notes(); ?>
                <!--                    </div>-->
                <!--                --><?php //endif; ?>
                <?php do_action('wpo_wcpdf_after_customer_notes', $this->get_type(), $this->order); ?>
            </td>
            <td class="no-borders totals-cell">

                <table class="totals">
                    <tfoot>
                    <?php
                    if ($tips) { ?>
                        <tr>
                            <th>Gesamt Netto (0.00 %)</th>
                            <td style="text-align: right;"><?php echo wc_price($tips); ?></td>
                        </tr>
                    <?php } ?>
                    <?php
                    $totals = $this->get_woocommerce_totals();

                    $order_total_float = 0.0;

                    if (isset($totals['order_total']['value'])) {
                        // Extragem partea numerică, ex: "83,19" din "83,19€(inkl. 5,22€ TVA)"
                        preg_match('/[\d\.,]+/', $totals['order_total']['value'], $matches);

                        if (!empty($matches)) {
                            // Convertim din format european (virgulă = punct zecimal) în float
                            $order_total_float = floatval(str_replace(',', '.', $matches[0]));
                        }
                    }
                    $shipping = $shipping_total;

                    $total = $order_total_float;

                    $discount = $this->order->discount_total;

                    $total_brut = $total - $tips;

                    $net = $total_brut / 1.07;

                    $tva = $total_brut - $net;

                    if ($discount) {
                        $total_brut = $total - $tips;
                        $net = $total_brut / 1.07;
                        $tva = $total_brut - $net;
                    }
                    //                    var_dump($total_brut);
                    ?>
                    <tr>
                        <th>Gesamt Netto (7.00 %)</th>
                        <td style="text-align: right;"><?php echo round($net, 2) ?>€</td>
                    </tr>
                    <?php
                    //                    var_dump($discount);
                    if ($discount) { ?>
                        <tr>
                            <th>Rabatt</th>
                            <td style="text-align: right;">-<?php echo round($discount, 2) ?>€</td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <th>zzgl. MwSt (7.00%)</th>
                        <td style="text-align: right;"><?php echo round($tva, 2) ?>€</td>
                    </tr>

                    <tr>
                        <th>Rechnungsbetrag:</th>
                        <td style="text-align: right;"><b style="font-weight: 700;"><?= $total ?>€</b></td>
                    </tr>
                    <tr>
                        <th>Zahlbetrag:</th>
                        <td style="text-align: right;"><b style="font-weight: 700;"><?= $total ?>€</b></td>
                    </tr>

                    <!--                    --><?php
                    //                    //                    var_dump($this->get_woocommerce_totals());
                    //                    foreach ($this->get_woocommerce_totals() as $key => $total) : ?>
                    <!--                        <tr class="--><?php //echo esc_attr($key); ?><!--">-->
                    <!--                            <th class="description">-->
                    <?php //echo esc_html($total['label']); ?><!--</th>-->
                    <!--                            <td class="price"><span class="totals-price">-->
                    <?php //echo esc_html($total['value']); ?><!--</span>-->
                    <!--                            </td>-->
                    <!--                        </tr>-->
                    <!--                    --><?php //endforeach; ?>
                    </tfoot>
                </table>

            </td>
        </tr>
        </tbody>
    </table>

<?php do_action('wpo_wcpdf_after_order_details', $this->get_type(), $this->order); ?>

    <div class="bottom-spacer">
        <table style="width: 100%; margin-top: 50px; border-top: 2px solid;">
            <tbody>
            <tr>
                <td>KRAGMAN GmbH</td>
                <td>USt-IdNr.:DE325225767</td>
                <td>KRAGMAN GmbH</td>
            </tr>
            <tr>
                <td>Werner-von-Siemens-Strasse 2-6 <br> 76646 Bruchsal <br>Tel: 015758868224 <br> info@kragman.de <br>www.kragman.de
                </td>
                <td>Amstgericht Mannheim: HRB 736728 <br> Geschäftsführer: Vadim Loghin</td>
                <td>Deutsche Bank <br> IBAN: DE17 5067 0024 0060 7150 00 <br>BIC: DEUTDEDB506</td>
            </tr>
            </tbody>
        </table>

    </div>

<?php if ($this->get_footer()) : ?>
    <htmlpagefooter name="docFooter"><!-- required for mPDF engine -->
        <div id="footer">
            <!-- hook available: wpo_wcpdf_before_footer -->
            <?php $this->footer(); ?>
            <!-- hook available: wpo_wcpdf_after_footer -->
        </div>
    </htmlpagefooter><!-- required for mPDF engine -->
<?php endif; ?>

<?php do_action('wpo_wcpdf_after_document', $this->get_type(), $this->order); ?>